#!/usr/bin/python3
#-*- coding: utf8 -*-
"""
    Génère le site y compris le lien vers la documentation du projet
"""
pass

# On fait les imports nécessaires selon le contexte
# Pour générer la documentation
import os
# Pour mesurer le temps de traitement du script
from datetime import datetime 

# Pour générer les pages web
import bloc1Pack.HTML_index as index
import bloc1Pack.HTML_global as complet
import bloc1Pack.HTML_global_formV1 as formulairev1
import bloc1Pack.HTML_global_formV2 as formulairev2

# Script principal
def main():
    # On récupère la date au début du traitement
    start_time = datetime.now()

    # On génère la documentation
    print("=============================================================================")
    print("  Création de la documentation en cours ...  ")    
    print(" ")
    os.system('sh ./generateMyDoc.sh')   

    # On génére page d'accueil
    print("=============================================================================")
    print("  Création de la page d'accueil en cours ...  ")    
    index.main()

    # On génère les pages avec tous les établissements    
    print("=============================================================================")
    print("  Création des fichiers HTML avec toutes les données initiales en cours ...  ")
    complet.main()

    # On génère la page avec le formulaire, la version avec chargement initial de toutes
    # toutes les lignes cachées
    print("=============================================================================")
    print("  Création du fichier HTML avec le formulaire en cours ...  ")    
    print("  Version avec les lignes cachées  ")    
    formulairev1.main()

    # On génère la page avec le formulaire, la version avec tableau javascript
    print("=============================================================================")
    print("  Création du fichier HTML avec le formulaire en cours ...  ")    
    print("  Version javascript  ")    
    formulairev2.main()

    # On évalue le temps de traitement
    end_time = datetime.now()
    print("=============================================================================")
    print("  Durée de traitement : ",end_time-start_time)        
    print("=============================================================================")
 
if __name__ == "__main__":
    main()