#!/usr/bin/python3
#-*- coding: utf8 -*-

# @author : Sébastien LOZANO
"""
    Génère la page d'accueil du site.
"""
pass

# On fait les imports nécessaires selon le contexte
# Pour pouvoir créer un répertoire, ici pour y mettre les fichiers HTML
import os

# On fait les imports nécessaires selon le contexte
# Pour générer les fichiers HTML 
if __name__ == "__main__":    
    from HTML_constantes import *
else:
    from bloc1Pack.HTML_constantes import *

############################################################################################################
# Générer le fichier pagesWeb/index.HTML
############################################################################################################

def main():
    """
        Fonction principale qui sera appelée pour générer l'ensemble des pages du site.    
    """
    pass

    # On crée le dossier qui va accueillir les fichiers HTML si il n'existe pas
    if not os.path.exists("./pagesWeb/"):
        os.mkdir("./pagesWeb/")

    # On ouvre en écriture le fichier html qui va recevoir le code
    indexHTML = open("./pagesWeb/index.html", "w")
    
    # On ajoute le doctype et le head
    for elt in docTypeHeadStyle:
        indexHTML.writelines(elt)
    
    # On ouvre le body
    indexHTML.writelines(["<body>\n"])

    # On ajoute les éléments de la barre de navigation
    for elt in barreDeNavigation:
        indexHTML.writelines(elt)  
    
    # On ajoute une partie spécifique
    indexHTML.writelines([
        """
        <h2>ACCUEIL</h2>\n
        <p> Le projet consiste à transférer les données d’un fichier csv dans un document HTML permettant d’en consulter le contenu.<br>
        Pour générer la documentation il faut installer le paquet python <a href="https://pdoc3.github.io/pdoc/" target="_blank"> pdoc3</a>
        </p>
        
        <h3>Auteur</h3>
        <p>Sébastien LOZANO</p>

        <h3> Installation et utilisation </h3>        
        <p>La procédure a été testé sous <b>Linux</b> uniquement.
        <ul>
        <li>Télécharger cette <a href="../python_prod.zip"> archive zip</a></li>
        <li>Décompresser l'archive</li>        
        <li>Lancer le script python <b>bloc1_generate_files.py</b> à la racine du projet.</li>
        </ul>
        </p>          

        <h3> Notes </h3>
        <p>
        Les fichiers de la documentations sont générés dans le dossier <b>docs</b><br><br>
        Les fichiers HTML sont générés dans le dossier <b>pagesWeb</b><br><br>
        Le script met environ <b>22 minutes</b> à créer l'ensemble des fichiers.<br><br>
        Deux versions pour le fichier HTML avec filtre par formulaire :
        <ul>
        <li><b>Version 1</b> : L'ensemble des lignes du tableau est généré dans le DOM puis cachées, l'affichage est ensuite géré dynamiquement via des scripts javascript mais l'ensemble des lignes reste dans le DOM.</li>
        <li><b>Version 2</b> : Un tableau javascript est générée via python, on gère ensuite le DOM et donc l'affichage dynamiquement via javascript.</li>
        </ul>
        </p>

        <h3> License <a href="https://choosealicense.com/licenses/mit/" target="_blank">MIT</a><h3>        
        """        
    ])
    
    # On ferme le body
    indexHTML.writelines([
    """    
    </body>\n
    </html>\n
    """
    ])
    
    #On ferme le fichier
    indexHTML.close()

if __name__ == "__main__":
    main()