#!/usr/bin/python3
#-*- coding: utf8 -*-

# @author : Sébastien LOZANO

"""Générer un fichier HTML qui contient un formulaire contenant :    

    * la liste des départements
    * un choix binaire « PRIMAIRE » « SECONDAIRE » (voir colonne C) 
    qui affiche en dessous la liste des établissements du département choisi par l’utilisateur
    et du niveau demandé (sous la forme d’un tableau comme spécifié au point précédent). 
    * Le tableau doit être trié selon :
        * les régions (colonne AB), index 27
        * puis les départements (colonne AA), index 25
        * puis le code de la commune (colonne I), index 8
        * puis le nom de l’établissement (colonne B) index 1
    * La ligne des titres doit visuellement se démarquer
    * Les autres lignes doivent être alternativement sur fond gris clair et blanc

    `Notes`

      Dans cette version, un tableau javascript est généré par le script python, on gère ensuite le DOM 
      et donc l'affichage dynamiquement via javascript.
        
"""
pass

# On fait les imports nécessaires selon le contexte
if __name__ == "__main__":    
    import PY_functions as b1f
    import HTML_constantes as html_const
else:
    import bloc1Pack.PY_functions as b1f
    import bloc1Pack.HTML_constantes as html_const

############################################################################################################
# Importation des bibliotheques
############################################################################################################
from operator import itemgetter # Pour la gestion du tri des listes de tuples
import os # Pour générer la documentation

############################################################################################################
# Générer un fichier HTML qui contient un formulaire contenant :
#===> la liste des départements
#===> un choix binaire « PRIMAIRE » « SECONDAIRE » (voir colonne C) 
#===> qui affiche en dessous la liste des établissements du département choisi par l’utilisateur
#      et du niveau demandé (sous la forme d’un tableau comme spécifié au point précédent). 
#===> Le tableau doit être trié selon :
#   ===> les régions (colonne AB), index 27
#   ===> puis les départements (colonne AA), index 25
#   ===> puis le code de la commune (colonne I), index 8
#   ===> puis le nom de l’établissement (colonne B) index 1
#   Le tri pourra se faire avec la fonction de tri de Python, prenant en argument
#   une fonction de comparaison ad hoc.
#===> La ligne des titres doit visuellement se démarquer
#===> Les autres lignes doivent être alternativement sur fond gris clair et blanc
############################################################################################################

# On commence par trier les données comme demandé avec la fonction de tri de python
# On supprime l'entete
list_of_tuples_tab_trie = b1f.global_list_of_tuples_tab[1:]
# Puis on trie
list_of_tuples_tab_trie = sorted(list_of_tuples_tab_trie,key=itemgetter(27,25,8,1))

#Décommenter pour tester avec une partie des données seulement
#list_of_tuples_tab_trie = list_of_tuples_tab_trie[0:7000]
#list_of_tuples_tab_trie = list_of_tuples_tab_trie[0:500]
#list_of_tuples_tab_trie = list_of_tuples_tab_trie[0:50]

# Gestion des catégories selon la colonne 19 nature_uai_libe
# On récupère toutes les dénominations
etab_all_nature_uai_libe=[]
for elt in list_of_tuples_tab_trie:
  etab_all_nature_uai_libe.append(elt[19])
# Pour compter les etablissements secondaires et primaires et vérifier qu'il n'y a pas d'oubli
sec=0
pri=0
# Pour les dénominations oubliées au cas où
etab_nature_uai_libe_oubli=[]
# Pour stocker les libellés des établissements du secondaire
etab_sec_nature_uai_libe = []
# Pour stocker les libellés des établissements du primaire
etab_pri_nature_uai_libe = []
for elt in etab_all_nature_uai_libe:
  if ("lycee" in elt.lower() or "college" in elt.lower() or "professionnel" in elt.lower()):
    sec+=1
    etab_sec_nature_uai_libe.append(elt.lower())
  elif ("ecole" in elt.lower()):
    pri+=1
    etab_pri_nature_uai_libe.append(elt.lower())
  else:
    sec+=1
    etab_sec_nature_uai_libe.append(elt.lower())
    etab_nature_uai_libe_oubli.append(elt.lower())
# On enlève les doublons éventuels de la liste des oublis
etab_nature_uai_libe_oubli_sans_doublons = []
for elt in etab_nature_uai_libe_oubli:
  if (elt not in etab_nature_uai_libe_oubli_sans_doublons):
    etab_nature_uai_libe_oubli_sans_doublons.append(elt)

if __name__ == "__main__":    
  ############ Pour savoir le nombre d'établissements traités ############  
  print("""
  =====================================================================================================
    Sortie pour connaître le nombre d'établissements traités et leur catégorie primaire ou secondaire  
  =====================================================================================================  
  nb de ligne du tuple global : {} ; total etab : {}
  nb d'etablissement catégorie secondaire : {} ; nb d'établissements catégorie primaire : {}
  nb d'établissements sans catégorie primaire/sceondaire: {}
  ===================================================================================================== 
  """.format(
    len(list_of_tuples_tab_trie),
    len(etab_all_nature_uai_libe),
    sec,
    pri,
    len(etab_all_nature_uai_libe)-pri-sec,
    )
  )
  ######### FIN ##############

def dataPrimaireSecondaire(chaine: str):
  """Fonction pour écrire un attribut universel de données correspondant au type d'étblissement.
  Primaire/Secondaire afin de permettre le choix binaire.

  `Paramètres`

      * chaine : Une chaine de caractères avec le contenu de la colonne '19'.

  `Sorties`

      * sortie : Une chaine de caractère valant 'primaire' ou 'secondaire'.

  """
  pass

  # On initialise la chaine de sortie
  sortie = ''
  for elt in etab_sec_nature_uai_libe:
    if chaine.lower() in elt:
      sortie = "secondaire"
  for elt in etab_pri_nature_uai_libe:       
    if chaine.lower() in elt:
      sortie = "primaire"
  return sortie


def main():
  # On crée le dossier qui va accueillir les fichiers HTML si il n'existe pas
  if not os.path.exists("./pagesWeb/"):
      os.mkdir("./pagesWeb/")

  #On ouvre en écriture le fichier html qui va recevoir le code
  fichierHTML3 = open("./pagesWeb/tableauFormV2.html", "w")

  # On ajoute le doctype et le head
  for elt in html_const.docTypeHeadStyle:
    fichierHTML3.writelines(elt)

  # On ouvre le body avec un spinner pour faire patienter le temps de chargement
  fichierHTML3.writelines([
    "<body onload=\"hideSpinner();\">\n"
  ])

  # On ajoute les éléments de la barre de navigation
  for elt in html_const.barreDeNavigation:
    fichierHTML3.writelines(elt)

  # On ajoute une partie spécifique
  fichierHTML3.writelines([
    """<h2>TABLEAU AVEC FORMULAIRE - VERSION 2<br>
       <span id="spinnerText">
          Attendez la fin du chargement de la page avant de sélectionner un département.<br>
          Je sais c'est un peu long !
       </span>
       </h2>\n
       <h3>Version avec un tableau javascript et une gestion dynamique du DOM.</h3>
       <div id=\"spinner\"></div>
    """
  ])
  # On ajoute un formulaire avec la liste des départements et le choix binaire "PRIMAIRE" "SECONDAIRE"

  # pour le debug : print(list_of_tuples_tab_trie[0:2])
  # On recupère la liste des départements
  departements = b1f.extract_col(list_of_tuples_tab_trie,26)
  #On supprime les doublons
  departements_sans_doublons = []
  for dep in departements :
    if (dep not in departements_sans_doublons) and (dep != 'libelle_departement') :
      departements_sans_doublons.append(dep)
  # On range les département par ordre alphabétique
  departements_sans_doublons.sort()

  # pour le debug : print(departements_sans_doublons[0:2])
  # début du formulaire
  fichierHTML3.writelines([
    """
    <form name=\"departements\" method=\"get\">
    \t<select name=\"liste_dep\" id=\"liste_dep\" onchange=\"filtrerDept(this);\">
    \t\t<option value=\"Selectionnez un departement ... \">Sélectionnez un département ... </option>\t
    """
  ])
  # On crée la liste déroulante avec tous les départements
  for dep in departements_sans_doublons :
    fichierHTML3.writelines([  
      "\t\t<option value=\""+dep+"\">"+dep+"</option>\n",
    ])
  # On crée le choix binaire "PRIMAIRE" "SECONDAIRE"
  fichierHTML3.writelines([
    """  
    \t</select>   
      <input type=\"radio\" name=\"pri_sec\" id=\"primaire\" value=\"primaire\" data-prisec=\"primaire\" onchange=\"filtrerPriSec(this);\">
      <label for="primaire">primaire</label>
      <input type=\"radio\" name=\"pri_sec\" id=\"secondaire\" value=\"secondaire\" data-prisec=\"secondaire\" onchange=\"filtrerPriSec(this);\">
      <label for="secondaire">secondaire</label>
      <input type=\"button\" value=\"Tous les établissements\" onclick=\"filtrerDept(document.getElementById('liste_dep'));\">          
    </form>\n
    <br>\n
    """
  ])

  # On génére un tableau js avec toutes les lignes des établissements  
  # On crée un constructeur et on initialise un tableau qui va recevoir les données.
  fichierHTML3.writelines(["<script type=\"text/javascript\">\n"])
  fichierHTML3.writelines(["function Etablissements("])
  for colonnes in b1f.global_list_of_tuples_tab[0]:
    fichierHTML3.writelines(["{},".format(colonnes)])      
  fichierHTML3.writelines(["prisec) {\n"])
  for colonnes in b1f.global_list_of_tuples_tab[0]:
    fichierHTML3.writelines(["this.{}={};\n".format(colonnes,colonnes)])      
  fichierHTML3.writelines(["this.prisec=prisec;\n"])
  fichierHTML3.writelines(["""
  };
    // Initialisation du tableau
    var tousLesEtabs = [];    
  """
  ])
  # On ajoute tous les éléments contenus dans le fichier csv global
  # Compteur pour le tableau tousLesEtabs
  cpt=0
  for lignes in list_of_tuples_tab_trie:    
    #print(lignes)
    #print("-----")
    # Un nouvel objet est instancier pour chaque ligne des données initiales
    fichierHTML3.writelines(["tousLesEtabs[{}]=new Etablissements(".format(cpt)])
    for colonnes in lignes:
      # si c'est la dernière colonne on ne met pas de virgule
      if colonnes == "date_ouverture":
        fichierHTML3.writelines(["\"{}\"".format(colonnes)])
      else:
        fichierHTML3.writelines(["\"{}\",".format(colonnes)])
    fichierHTML3.writelines(["\"{}\");\n".format(dataPrimaireSecondaire(lignes[19]),lignes[26])])
    cpt+=1

  fichierHTML3.writelines([
    """            
    </script>
    """
  ])

  # On crée le tableau
  fichierHTML3.writelines([
    "<table id=\"monTab\">\n",
  ])

  # On affiche les entetes
  fichierHTML3.writelines(["<tr>"])
  for colonnes in b1f.global_list_of_tuples_tab[0]:
    fichierHTML3.writelines(["<th>{}</th>".format(colonnes)])      
  fichierHTML3.writelines(["</tr>\n"])

  # On affiche le reste
  # compteur de ligne pour la couleur du background
  fichierHTML3.writelines(["""
    <script>
      // Pour récupérer les éléments à afficher
      // Selon primaire ou secondaire
      // Selon le département
      function toutCeQueJeVeux(prisec,dept) {
        // On vide le tableau sauf la premiere ligne
        var myNode = document.getElementById("monTab"); 
        while (myNode.rows[1]) { 
          myNode.removeChild(myNode.rows[1]); 
        };
        // Récupérer l'état du radio de sélection primaire/secondaire
          let radioState = false;
          let local_prisec = document.forms[0].elements["pri_sec"];
          for (var i=0;i<local_prisec.length;i++) {
            if (local_prisec[i].checked == true) {
              radioState = true;          
            };
          };
        // Compteur pour la couleur du background des lignes sauf la première
        let cpt = 1;
        // Variable pour le contenu d'une ligne
        let TR;
        // Variable pour le contenu d'une colonne
        let TD;
        // Variable pour le texte d'une colonne
        let TXT;
        // On recupère uniquement les établisssements voulus
        let ceQueJeVeux= [];      
        for (let i=0;i<tousLesEtabs.length;i++) {
          // si l'une des valeurs du formulaire radio est selectionné
          if (radioState) {
            // Si le data de l'établissement correspond à ce qu'on veut, primaire ou secondaire
            // ainsi qu'au département voulu
            // on ajoute l'établissement au tableau
            if (tousLesEtabs[i].prisec == prisec && tousLesEtabs[i].libelle_departement == dept) {
              ceQueJeVeux.push(tousLesEtabs[i])
            };
          } else {
            // Si le radio primaire/secondaire n'est pas sélectionné
            // On ajoute tous les établissements du département            
            if (tousLesEtabs[i].libelle_departement == dept) {
              ceQueJeVeux.push(tousLesEtabs[i])
            };
          };
        };

        // On crée tous les éléments à ajouter au DOM un à un
        // en fonction de ce que contient le tableau tousLesEtabs      
        for (let i=0;i<ceQueJeVeux.length;i++) {      
          // On crée la ligne
          TR = document.createElement("tr");
          // On ajoute un data pour la gestion du primaire/secondaire
          TR.dataset.prisec = ceQueJeVeux[i].prisec;
          // On ajoute un data pour la gestion du département
          TR.dataset.dept = ceQueJeVeux[i].code_departement;
          // Selon la parité du compteur on ajuste le background avec une class
          if (cpt%2 == 0) {
            TR.classList.add("evenNthChildBackground");
          } else {
            TR.classList.add("oddNthChildBackground");
          };

          // On ajoute les colonnes et le contenu à la ligne
          for (colonnes in ceQueJeVeux[i]) {
            if (colonnes != "prisec") {
              TD = document.createElement("td");
              TXT = document.createTextNode(ceQueJeVeux[i][colonnes]);
              TD.appendChild(TXT);
              TR.appendChild(TD);
            };        
          };

          // On ajoute la ligne au tableau            
          document.getElementById('monTab').appendChild(TR);

          // On incrémente le compteur pour passer à la ligne suivante
          cpt+=1;        
        };      
      };
    </script>
    """
  ])

  # On ferme le tableau HTML
  fichierHTML3.writelines([
    "</table>\n",
  ])

  # On ferme le body et on écrit les script javascript
  fichierHTML3.writelines([
    """    
    <script type="text/javascript">\n
      // Pour gérer l'affichage du spinner et du texte pour faire patienter
      function hideSpinner() {
            document.getElementById('spinner').style.display = 'none';
            document.getElementById('spinnerText').style.display = 'none';
      };

      // Pour filtrer les établissements du primaire ou du secondaire 
      function filtrerPriSec(elem) {
          // Récupérer le data du radio primaire/secondaire
          var data_prisec = elem.dataset.prisec; 

          // Récupérer le texte selectionné de la liste déroulante      
          var data_dept = document.getElementById('liste_dep').options[document.getElementById('liste_dep').selectedIndex].text;

          // Récupérer l'état du radio
          var radioState = false;
          var prisec = document.forms[0].elements["pri_sec"];
          for (var i=0;i<prisec.length;i++) {
            if (prisec[i].checked == true) {
              radioState = true;          
            };
          };

          // Mettre à jour le DOM avec la fonction toutCeQueJeVeux()
          toutCeQueJeVeux(data_prisec,data_dept);        
      }

      // Pour filtrer les établissements d'un département donné
      function filtrerDept(elem) {
          // Remettre le radio à zéro
          var prisec = document.forms[0].elements["pri_sec"];
          for (var i=0;i<prisec.length;i++) {
            prisec[i].checked = false;
          };

          // Récupérer le texte du select
          var data_dept = elem.options[elem.selectedIndex].text;
          console.log("filtrerDept : "+data_dept)

          // Mettre à jour le DOM avec la fonction toutCeQueJeVeux()
          // Le premier paramètre est une chaine arbitraire autre que "primaire" ou "secondaire"
          // afin que tous les établissements du département soient ajoutés au tableau ceQueJeVeux
          // de la fonction toutCeQueJeVeux()
          toutCeQueJeVeux("nada",data_dept);
      };
    </script>
    </body>\n
    </html>\n
    """
  ])

  #On ferme le fichier
  fichierHTML3.close()

if __name__ == "__main__":   
    main()    