#!/usr/bin/python3
#-*- coding: utf8 -*-

# @author : Sébastien LOZANO

"""Générer un fichier HTML qui contient un formulaire contenant :

    * la liste des départements
    * un choix binaire « PRIMAIRE » « SECONDAIRE » (voir colonne C) 
    qui affiche en dessous la liste des établissements du département choisi par l’utilisateur
    et du niveau demandé (sous la forme d’un tableau comme spécifié au point précédent). 
    * Le tableau doit être trié selon :
        * les régions (colonne AB), index 27
        * puis les départements (colonne AA), index 25
        * puis le code de la commune (colonne I), index 8
        * puis le nom de l’établissement (colonne B) index 1
    * La ligne des titres doit visuellement se démarquer
    * Les autres lignes doivent être alternativement sur fond gris clair et blanc

    `Notes`

      Dans cette version, l'ensemble des lignes du tableau est généré dans le DOM puis cachées, l'affichage est ensuite
      géré dynamiquement via des scripts javascript mais l'ensemble des lignes reste dans le DOM.
"""
pass

# On fait les imports nécessaires selon le contexte
if __name__ == "__main__":    
    import PY_functions as b1f
    import HTML_constantes as html_const
else:
    import bloc1Pack.PY_functions as b1f
    import bloc1Pack.HTML_constantes as html_const

############################################################################################################
# Importation des bibliotheques
############################################################################################################
from operator import itemgetter # Pour la gestion du tri des listes de tuples
import os # Pour générer la documentation

############################################################################################################
# Générer un fichier HTML qui contient un formulaire contenant :
#===> la liste des départements
#===> un choix binaire « PRIMAIRE » « SECONDAIRE » (voir colonne C) 
#===> qui affiche en dessous la liste des établissements du département choisi par l’utilisateur
#      et du niveau demandé (sous la forme d’un tableau comme spécifié au point précédent). 
#===> Le tableau doit être trié selon :
#   ===> les régions (colonne AB), index 27
#   ===> puis les départements (colonne AA), index 25
#   ===> puis le code de la commune (colonne I), index 8
#   ===> puis le nom de l’établissement (colonne B) index 1
#   Le tri pourra se faire avec la fonction de tri de Python, prenant en argument
#   une fonction de comparaison ad hoc.
#===> La ligne des titres doit visuellement se démarquer
#===> Les autres lignes doivent être alternativement sur fond gris clair et blanc
############################################################################################################

# On commence par trier les données comme demandé avec la fonction de tri de python
# On supprime l'entete
list_of_tuples_tab_trie = b1f.global_list_of_tuples_tab[1:]
# Puis on trie
list_of_tuples_tab_trie = sorted(list_of_tuples_tab_trie,key=itemgetter(27,25,8,1))

#Décommenter pour tester avec une partie des données seulement
#list_of_tuples_tab_trie = list_of_tuples_tab_trie[0:7000]
#list_of_tuples_tab_trie = list_of_tuples_tab_trie[0:70]

# Gestion des catégories selon la colonne 19 nature_uai_libe
# On récupère toutes les dénominations
etab_all_nature_uai_libe=[]
for elt in list_of_tuples_tab_trie:
  etab_all_nature_uai_libe.append(elt[19])
# Pour compter les etablissements secondaires et primaires et vérifier qu'il n'y a pas d'oubli
sec=0
pri=0
# Pour les dénominations oubliées au cas où
etab_nature_uai_libe_oubli=[]
# Pour stocker les libellés des établissements du secondaire
etab_sec_nature_uai_libe = []
# Pour stocker les libellés des établissements du primaire
etab_pri_nature_uai_libe = []
for elt in etab_all_nature_uai_libe:
  if ("lycee" in elt.lower() or "college" in elt.lower() or "professionnel" in elt.lower()):
    sec+=1
    etab_sec_nature_uai_libe.append(elt.lower())
  elif ("ecole" in elt.lower()):
    pri+=1
    etab_pri_nature_uai_libe.append(elt.lower())
  else:
    sec+=1
    etab_sec_nature_uai_libe.append(elt.lower())
    etab_nature_uai_libe_oubli.append(elt.lower())
# On enlève les doublons éventuels de la liste des oublis
etab_nature_uai_libe_oubli_sans_doublons = []
for elt in etab_nature_uai_libe_oubli:
  if (elt not in etab_nature_uai_libe_oubli_sans_doublons):
    etab_nature_uai_libe_oubli_sans_doublons.append(elt)

if __name__ == "__main__":    
  ############ Pour savoir le nombre d'établissements traités ############  
  print("""
  =====================================================================================================
    Sortie pour connaître le nombre d'établissements traités et leur catégorie primaire ou secondaire  
  =====================================================================================================  
  nb de ligne du tuple global : {} ; total etab : {}
  nb d'etablissement catégorie secondaire : {} ; nb d'établissements catégorie primaire : {}
  nb d'établissements sans catégorie primaire/sceondaire: {}
  ===================================================================================================== 
  """.format(
    len(list_of_tuples_tab_trie),
    len(etab_all_nature_uai_libe),
    sec,
    pri,
    len(etab_all_nature_uai_libe)-pri-sec,
    )
  )
  ######### FIN ##############
 
def dataPrimaireSecondaire(chaine: str):
  """Fonction pour écrire un attribut universel de données correspondant au type d'étblissement.
  Primaire/Secondaire afin de permettre le choix binaire.

  `Paramètres`

      * chaine : Une chaine de caractères avec le contenu de la colonne '19'.

  `Sorties`

      * sortie : Une chaine de caractère valant 'primaire' ou 'secondaire'.

  """
  pass

  # On initialise la chaine de sortie
  sortie = ''
  for elt in etab_sec_nature_uai_libe:
    if chaine.lower() in elt:
      sortie = "secondaire"
  for elt in etab_pri_nature_uai_libe:       
    if chaine.lower() in elt:
      sortie = "primaire"
  return sortie


def main():
  # On crée le dossier qui va accueillir les fichiers HTML si il n'existe pas
  if not os.path.exists("./pagesWeb/"):
      os.mkdir("./pagesWeb/")

  #On ouvre en écriture le fichier html qui va recevoir le code
  fichierHTML3 = open("./pagesWeb/tableauFormV1.html", "w")

  # On ajoute le doctype et le head
  for elt in html_const.docTypeHeadStyle:
    fichierHTML3.writelines(elt)

  # On ouvre le body avec un spinner pour faire patienter le temps de chargement
  fichierHTML3.writelines([
    "<body onload=\"hideSpinner();\">\n"
  ])

  # On ajoute les éléments de la barre de navigation
  for elt in html_const.barreDeNavigation:
    fichierHTML3.writelines(elt)

  # On ajoute une partie spécifique
  fichierHTML3.writelines([
    """<h2>TABLEAU AVEC FORMULAIRE - VERSION 1<br>
       <span id="spinnerText">
          Attendez la fin du chargement de la page avant de sélectionner un département.<br>
          Je sais c'est un peu long !
       </span>
       </h2>\n
       <div id=\"spinner\"></div>
       <h3>Version avec un tableau statique et des lignes initialement cachées</h3>
    """
  ])
  # On ajoute un formulaire avec la liste des départements et le choix binaire "PRIMAIRE" "SECONDAIRE"

  # pour le debug : print(list_of_tuples_tab_trie[0:2])
  # On recupère la liste des départements
  departements = b1f.extract_col(list_of_tuples_tab_trie,26)
  #On supprime les doublons
  departements_sans_doublons = []
  for dep in departements :
    if (dep not in departements_sans_doublons) and (dep != 'libelle_departement') :
      departements_sans_doublons.append(dep)
  # On range les département par ordre alphabétique
  departements_sans_doublons.sort()

  # pour le debug : print(departements_sans_doublons[0:2])
  # début du formulaire
  fichierHTML3.writelines([
    """
    <form name=\"departements\" method=\"get\">
    \t<select name=\"liste_dep\" id=\"liste_dep\" onchange=\"filtrerDept(this);majColor();\">
    \t\t<option value=\"Selectionnez un departement ... \">Sélectionnez un département ... </option>\t
    """
  ])
  # On crée la liste déroulante avec tous les départements
  for dep in departements_sans_doublons :
    fichierHTML3.writelines([  
      "\t\t<option value=\""+dep+"\">"+dep+"</option>\n",
    ])
  # On crée le choix binaire "PRIMAIRE" "SECONDAIRE"
  fichierHTML3.writelines([
    """  
    \t</select>   
      <input type=\"radio\" name=\"pri_sec\" id=\"primaire\" value=\"primaire\" data-prisec=\"primaire\" onchange=\"filtrerPriSec(this);majColor();\">
      <label for="primaire">primaire</label>
      <input type=\"radio\" name=\"pri_sec\" id=\"secondaire\" value=\"secondaire\" data-prisec=\"secondaire\" onchange=\"filtrerPriSec(this);majColor();\">
      <label for="secondaire">secondaire</label>
      <input type=\"button\" value=\"Tous les établissements\" onclick=\"filtrerDept(document.getElementById('liste_dep'));majColor();\">          
    </form>\n
    <br>\n
    """
  ])

  # On crée le tableau
  fichierHTML3.writelines([
    "<table>\n",
  ])

  # On affiche les entetes
  fichierHTML3.writelines(["<tr>"])
  for colonnes in b1f.global_list_of_tuples_tab[0]:
    fichierHTML3.writelines(["<th>{}</th>".format(colonnes)])      
  fichierHTML3.writelines(["</tr>\n"])

  # On affiche le reste
  # compteur de ligne pour la couleur du background
  cpt = 1
  for lignes in list_of_tuples_tab_trie:
    if (cpt%2 == 0):
      fichierHTML3.writelines(["<tr style=\"display: none;\" class=\"evenNthChildBackground\" data-prisec=\"{}\" data-dept=\"{}\">".format(dataPrimaireSecondaire(lignes[19]),lignes[26])])
    else:
      fichierHTML3.writelines(["<tr style=\"display: none;\" class=\"oddNthChildBackground\" data-prisec=\"{}\" data-dept=\"{}\">".format(dataPrimaireSecondaire(lignes[19]),lignes[26])])
    cpt+=1
    for colonnes in lignes:
      fichierHTML3.writelines(["<td>{}</td>".format(colonnes)])      
    fichierHTML3.writelines(["</tr>\n"])

  # On ferme le body et on écrit les script javascript
  fichierHTML3.writelines([
    """
    </table>\n
    <script type="text/javascript">\n
      // Pour gérer l'affichage du spinner et du texte pour faire patienter
      function hideSpinner() {
            document.getElementById('spinner').style.display = 'none';
            document.getElementById('spinnerText').style.display = 'none';
      };
      
      // Pour filtrer les établissements du primaire ou du secondaire 
      function filtrerPriSec(elem) {
          // Récupérer le data du radio primaire/secondaire
          var data_prisec = elem.dataset.prisec; 

          // Récupérer le texte selectionné de la liste déroulante      
          var data_dept = document.getElementById('liste_dep').options[document.getElementById('liste_dep').selectedIndex].text;        

          // Récupérer l'état du radio
          var radioState = false;
          var prisec = document.forms[0].elements["pri_sec"];
          for (var i=0;i<prisec.length;i++) {
            if (prisec[i].checked == true) {
              radioState = true;          
            };
          };

          // Parcourir toutes les lignes du tableau
          var row = document.getElementsByTagName('tr'); 
          // Afficher l'entete donc on commence la boucle à 1
          for (var i = 1; i < row.length; i++) {
            // si le select est à Sélectionnez un département ... on affiche rien
            if (data_dept == "Sélectionnez un département ...") {          
              row[i].style.display = "none"
            } else {
              // Si le radio est à zero on affiche toutes les lignes du departement
              if (radioState == false) {
                // Cacher toutes les lignes dont le data_dept ne correspond pas
                if(row[i].dataset.dept != data_dept) row[i].style.display = 'none'; 
                // Afficher toutes les lignes dont le data-dept correspond si jamais elles étaient cachées
                if(row[i].dataset.dept == data_dept) row[i].style.display = 'table-row';
              } else {
                // Cacher les lignes qui n'ont pas le bon data primaire/secondaire ou pas le bon data_dept
                if(row[i].dataset.prisec != data_prisec || row[i].dataset.dept != data_dept) row[i].style.display = 'none'; 
                // Afficher celles qui ont les deux bons si jamais elles avaient été cachées
                if(row[i].dataset.prisec == data_prisec && row[i].dataset.dept == data_dept) row[i].style.display = 'table-row';
              };
            };
          };      
        };
      
      // Pour filtrer les établissements d'un département donné
      function filtrerDept(elem) {      
        // Remettre le radio à zéro
        var prisec = document.forms[0].elements["pri_sec"];
        for (var i=0;i<prisec.length;i++) {
          prisec[i].checked = false;
        };

        // Récupérer le texte du select
        var data_dept = elem.options[elem.selectedIndex].text;

        // Parcourir toutes les lignes du tableau
        var row = document.getElementsByTagName('tr');
        // Afficher l'entete donc on commence la boucle à 1
        for (var i = 1; i < row.length; i++) {
          // si le select est à Sélectionnez un département ... on affiche tout
          if (data_dept == "Sélectionnez un département ...") {          
            row[i].style.display = "none"
          } else {
            // Cacher les lignes qui n'ont pas le bon data_dept
            if(row[i].dataset.dept != data_dept) row[i].style.display = 'none';
            // Afficher celles qui ont le bon si jamais elles avaient été cachées
            if(row[i].dataset.dept == data_dept) row[i].style.display = 'table-row';
          };
        };
      };

      // Pour mettre à jour la couleur des background des lignes du tableau
      function majColor() {      
        // on mets à jour tous les background des lignes du tableau
        row = document.getElementsByTagName(\"tr\");
        // Un compteur pour la parité de la ligne
        cpt = 1;
        for (var i =1; i<row.length; i++) {
          // si la ligne est affichée on modifie le style en fonction de la partié de cpt,
          if (row[i].style.display == 'table-row') {
            if (cpt%2 == 0 && row[i].classList.contains("oddNthChildBackground")) {    
              row[i].classList.remove("oddNthChildBackground")
              row[i].classList.add("evenNthChildBackground")            
            };
            if (cpt%2 == 1 && row[i].classList.contains("evenNthChildBackground")) {
              row[i].classList.remove("evenNthChildBackground")
              row[i].classList.add("oddNthChildBackground")            
            };
            cpt+=1;
          };
        };
      };
    </script>
    </body>\n
    </html>\n
    """
  ])

  #On ferme le fichier
  fichierHTML3.close()

if __name__ == "__main__":   
    main()    