#!/usr/bin/python3
#-*- coding: utf8 -*-

# @author : Sébastien LOZANO

"""Générer un fichier HTML contenant toutes les données du fichier initial sous la forme d’un tableau (balise table) statique. Étant donné le nombre important de lignes du tableau initial, 66 096, on fait le choix de générer plusieurs fichiers HTML pour séparer ce tableau en sous-tableaux et ainsi afficher toutes les données sur plusieurs pages. Ainsi le navigateur est soulagé et l'affichage plus rapide !    

    * Le tableau doit être trié selon :
        * les régions (colonne AB), index 27
        * puis les départements (colonne AA), index 25
        * puis le code de la commune (colonne I), index 8
        * puis le nom de l’établissement (colonne B) index 1
    * La ligne des titres doit visuellement se démarquer
    * Les autres lignes doivent être alternativement sur fond gris clair et blanc
"""
pass

# On fait les imports nécessaires selon le contexte
if __name__ == "__main__":    
    import PY_functions as b1f
    import HTML_constantes as html_const
else:
    import bloc1Pack.PY_functions as b1f
    import bloc1Pack.HTML_constantes as html_const

############################################################################################################
# Importation des bibliotheques
############################################################################################################
from operator import itemgetter # Pour la gestion du tri des listes de tuples
import os # Notamment pour générer la documentation et la création de répertoires

############################################################################################################
# Générer un fichier HTML contenant toutes les données du fichier initial sous la forme 
# d’un tableau (balise table) statique
#===> Le tableau doit être trié selon :
#   ===> les régions (colonne AB), index 27
#   ===> puis les départements (colonne AA), index 25
#   ===> puis le code de la commune (colonne I), index 8
#   ===> puis le nom de l’établissement (colonne B) index 1
#   Le tri pourra se faire avec la fonction de tri de Python,
#   prenant en argument une fonction de comparaison ad hoc.
#===> La ligne des titres doit visuellement se démarquer
#===> Les autres lignes doivent être alternativement sur fond gris clair et blanc
#
# Étant donné le nombre important de lignes du fichier csv,
# On crée un fichier HTML pour subdiviser les données du fichier csv 
# et ainsi diminuer le temps de chargement
############################################################################################################

# Le tableau global a été extrait dans le module bloc1Pack.PY_functions dans la variable global_list_of_tuples_tab
# On commence par trier les données comme demandé avec la fonction de tri de python
# On supprime l'entete
global_list_of_tuples_tab_trie = b1f.global_list_of_tuples_tab[1:]
# Puis on trie
global_list_of_tuples_tab_trie = sorted(global_list_of_tuples_tab_trie,key=itemgetter(27,25,8,1))

# Le tableau global a été extrait dans le module bloc1Pack.PY_functions dans la variable global_list_of_tuples_tab
# On va le découper et récupérer les morceaux dans une liste de listes
# afin de pouvoir découper les pages HTML et diminuer le temps de chargement
# On génère 40 fichiers
nb_parts = 40
# La méthode cut_list du sous module bloc1Pack.PY_functions divise une liste
# en liste de sous-listes
lists_of_tuples_tab_trie = b1f.cut_list(global_list_of_tuples_tab_trie,nb_parts)

def create_page(filename: str,index: str):
    """Crée un fichier HTML pour chaque liste de tuples issue du découpage de l'extraction du fichier csv global.

        `Paramètres`

            * filename : Une chaine de caractères correspondant à lapartie commune des fichiers HTML.
            * index : Une chaine de caractères contenant l'index du tuple contenant les données.

        `Sorties`

            * Un fichier HTML
        
        `Notes`
            Cette fonction permet de générer automatiquement les pages contenant toutes les données du fiochier csv global
            et la navigation entre celles-ci.  
    """
    pass

    # On définit les index précédents et suivants pour gérer la navigation
    if (index == str(nb_parts)):
        indexPrec = int(index)-1
        indexSuiv = 1        
    elif (index == '1'):
        indexPrec = nb_parts
        indexSuiv = int(index)+1
    else:
        indexPrec = int(index)-1
        indexSuiv = int(index)+1

    # On crée le dossier qui va accueillir les fichiers HTML si il n'existe pas
    if not os.path.exists("./pagesWeb/"):
        os.mkdir("./pagesWeb/")

    #On ouvre en écriture le fichier html qui va recevoir le code
    fichierHTML1 = open("./pagesWeb/tableauComplet_"+index+".html", "w")

    # On ajoute le doctype et le head
    for elt in html_const.docTypeHeadStyle:
        fichierHTML1.writelines(elt)

    # On ouvre le body
    fichierHTML1.writelines([
    "<body>\n"
    ])
    
    # On ajoute les éléments de la barre de navigation
    for elt in html_const.barreDeNavigation:
        fichierHTML1.writelines(elt)
    
    fichierHTML1.writelines([
        """
        <script>
            // Pour aller directement à une page donnée indiquée par l'utilisateur
            function directement_page(n) {                
                let cible = document.getElementById("nb_direct");
                cible.innerHTML = `<a class="suivButton" href="./tableauComplet_${n}.html"><span>en cliquant ici !</span></a>`;
            };
        </script>
        """
    ])
    # On ajoute une partie spécifique
    fichierHTML1.writelines([
    "<h2>TABLEAU AVEC TOUTES LES DONNÉES DU FICHIER INITIAL SUR "+str(nb_parts)+" PAGES</h2>\n",    
    "<h3><a class=\"precButton\" href=\"./tableauComplet_"+str(indexPrec)+".html\" target=\"_self\"><span>Vers la page "+str(indexPrec)+"</span></a> <span class=\"currentButton\"> Vous êtes page "+index+"</span> <a class=\"suivButton\" href=\"./tableauComplet_"+str(indexSuiv)+".html\" target=\"_self\"><span> Vers la page "+str(indexSuiv)+"</span></a></h3>\n",
    "<h4>Changer la valeur pour aller directement à la page <input id=\"direct_input\" type=\"number\" step=\"1\" value=\""+index+"\" min=\"1\" max=\"40\" onchange=\"directement_page(this.value)\"> <span id=\"nb_direct\"></span> </h4>"    
    ])

    # On ouvre le tableau HTML
    fichierHTML1.writelines([
    "<table>\n",
    ])

    # On affiche les entetes
    fichierHTML1.writelines(["<tr>"])
    for colonnes in b1f.global_list_of_tuples_tab[0]:
        fichierHTML1.writelines(["<th>{}</th>".format(colonnes)])      
    fichierHTML1.writelines(["</tr>\n"])

    # On affiche le reste
    # compteur de ligne pour la couleur du background
    cpt = 1
    for lignes in lists_of_tuples_tab_trie[int(index)-1]:
        if (cpt%2 == 0):
            fichierHTML1.writelines(["<tr class=\"evenNthChildBackground\">"])
        else:
            fichierHTML1.writelines(["<tr class=\"oddNthChildBackground\">"])
        cpt+=1
        for colonnes in lignes:
            fichierHTML1.writelines(["<td>{}</td>".format(colonnes)])      
        fichierHTML1.writelines(["</tr>\n"])

    # On ferme le tableau HTML et le body
    fichierHTML1.writelines([
    """
    </table>\n
    </body>\n
    </html>\n
    """
    ])

    #On ferme le fichier
    fichierHTML1.close()    

def main():
    """Fonction principale qui sera appelée pour générer l'ensemble des pages du site.

    """
    pass

    # On numérote les pages de 1 à nb_parts
    for i in range(1,nb_parts+1) :
        create_page("./pagesWeb/tableauComplet_",str(i))
    
if __name__ == "__main__":
    main()