#!/usr/bin/python3
#-*- coding: utf8 -*-

# @author : Sébastien LOZANO

"""Générer les parties communes aux fichiers HTML.

  On met les constantes dans des chaînes.

"""
pass

docTypeHead = (
  """
<!doctype html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">    
    <title>Bloc1-Python-DIEUEIL</title>
</head>
"""
)

style = (
  """
<style>
table {
  font-family: arial, sans-serif;
  font-size: 0.75rem;
  border-collapse: collapse;
  width: 100%;
}
td,th {
  border: 1px solid #dddddd;
  text-align: left;
  padding: 8px;
}
tr:nth-child(even) {
  background-color: #dddddd;
}
tr:first-child {
  background-color: #ff7f00;
}
</style>
"""
)

docTypeHeadStyle = (
  """
<!doctype html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">    
    <title>Bloc1-Python-DIEUEIL</title>
    <style>
      table {
        font-family: arial, sans-serif;
        font-size: 0.75rem;
        border-collapse: collapse;
        width: 100%;
      }
      td,th {
        border: 1px solid #dddddd;
        text-align: left;
        padding: 8px;
      }
      .evenNthChildBackground {
          background-color: #dddddd;
      }
      .oddNthChildBackgroung {
          background-color: #ffffff;
      }
      tr:first-child {
        background-color: #ff7f00;
      }
      .navButton, .precButton, .suivButton, .currentButton {
        display: inline-block;
        border-radius: 4px;
        background-color: #ff7f00;
        color: #FFFFFF;
        text-align: center;
        font-size: 1rem;
        padding: 0.75rem;
        width: auto;
        transition: all 0.5s;
        margin: 0.3rem;
      }
      .navButton {
        font-weight: bold;
      }
      .navButton, .precButton, .suivButton {
        border: none;
        cursor: pointer;
      }
      .precButton, .suivButton {
        background-color: #9c9c9c;
      }
      .navButton span, .precButton span, .suivButton span {
        cursor: pointer;
        display: inline-block;
        position: relative;
        transition: 0.5s;
      }
      .navButton span:after, .suivButton span:after {
        content: '\\00bb';
        position: absolute;
        opacity: 0;
        top: 0;
        right: -1.25rem;
        transition: 0.5s;
      }
      .precButton span:after {
        content: '\\00ab';
        position: absolute;
        opacity: 0;
        top: 0;
        left: -9.25rem;
        transition: 0.5s;
      }
      .precButton:hover span {
        padding-left: 1.5rem;
      }
      .navButton:hover span, .suivButton:hover span {
        padding-right: 1.5rem;
      }
      .navButton:hover span:after, .precButton:hover span:after, .suivButton:hover span:after {
        opacity: 1;
        right: 0;
      }
      #spinner{
        width: 7.5rem;
        height: 7.5rem;
        background: transparent;
        border-left: 10px solid #9c9c9c;/*gray;*/
        border-right: 10px solid #9c9c9c;/*gray;*/
        border-top: 10px solid #ff7f00;/*lightgreen;*/
        border-bottom: 10px solid #9c9c9c;/*gray;*/
        position: absolute;
        left: 50%;
        top: 55%;
        margin-left: -3.75rem;
        /*margin-top: -3.75rem;*/
        border-radius: 50%;
        animation: loader 1.5s linear infinite;
      }
      @keyframes loader{
        100%{
          transform: rotate(360deg);
        }
      }
      #direct_input {
        width:1rem;
        -moz-appearance: textfield;
      }
    </style>
</head>
"""
)

barreDeNavigation = (
  """
<h1>BLOC 1 - PROJET PYTHON/HTML</h1>
<hr>
<h4>Source des données : <a href=\"https://www.data.gouv.fr/fr/datasets/adresse-et-geolocalisation-des-etablissements-denseignement-du-premier-et-second-degres-1/\" target=\"_blank\">https://www.data.gouv.fr</a></h4>
<hr>
<a class="navButton" href=\"index.html\" target=\"_self\"><span>Accueil</span></a>
<a class="navButton" href=\"tableauComplet_1.html\" target=\"_self\"><span>Toutes les données initiales</span></a>
<a class="navButton" href=\"tableauFormV1.html\" target=\"_self\"><span>Formulaire Version1</span></a>
<a class="navButton" href=\"tableauFormV2.html\" target=\"_self\"><span>Formulaire Version2</span></a>
<a class="navButton" href=\"../docs/bloc1Pack/index.html\" target=\"_blank\"><span>Documentation</span></a>
<hr>
"""
)